
//NUTRADIUS_6 = 10/2 + 0.2;
NUTRADIUS_6 = 9/2 + 0.2;
BOLTRADIUS_6 = 4/2;

NUTRADIUS_10 = 10.7/2 + 0.2;
BOLTRADIUS_10 = 5/2;


//default is for #6 bolt
//NOTE: length does not include the portion inside or extending beyond the nut, or the head of the bolt
module printablenuthole(length=50, boltradius=BOLTRADIUS_6, nutradius=NUTRADIUS_6){
	translate([0,0])cylinder(length+5,boltradius,boltradius);//bolt
	translate([0,0,length])cylinder(length,nutradius+1.5,nutradius*3);//room for head

	//this prevents us from bridging to empty space
	//NOTE: using difference instead of intersection seems to improve performance and reduce glitches
	difference() {
		//0.4mm should be at least one layer
		translate([0,0,-5])cylinder(5.4,nutradius,nutradius,$fn=6);//nut
		scale([1,nutradius*2, 2])translate([boltradius,-0.5,0])scale([nutradius,1,1])cube();
		scale([-1,nutradius*2, 2])translate([boltradius,-0.5,0])scale([nutradius,1,1])cube();
	}
	//second shelf, prevent needing to bridge half circles over free space
	translate([-boltradius,-boltradius,0])scale([boltradius*2,boltradius*2,0.4*2])cube();

	//this gives us a flange so the nut can go in easier
	translate([0,0,-5 +1.5 -3])cylinder(4,nutradius+1+2,nutradius,$fn=6);//nut
}
