include <lib/cubes.scad>
include <lib/boltholes.scad>
$fn=100;

//============begin configuration============
//battery dimensions (designed for 21700)
extraspace = 0.5;
batth = 70.80+extraspace;
battr = (21.44+extraspace)/2;
battspacing = 25; //must be more than 2 * battr
//how many batteries in the grid
battsx = 4;
battsy = 3;
includetabs = true;
//============end configuration============

module batt(){
	cylinder(batth, battr, battr);

}

module battcutout(){
	translate([0,0,1-0.01])union(){
		translate([0,0,-2]) batt();
		hull(){
			intersection(){
				cylinder(2, battr, battr);
				xycube(10, battr*2, 10);
			}
			xycube(10, battr*2, -1);
		}
		hull(){
			intersection(){
				cylinder(2, battr, battr);
				xycube(battr*2, 10, 10);
			}
			xycube(battr*2, 10, -1);
		}
	}
	xycube(50, 10, -20);
	xycube(10, 50, -20);

	//round off plus
	difference(){
		xycube(10+2, 10+2, -20);
		for(i=[0:90:270])
			rotate([0,0,i])translate([12/2,12/2,0])cylinder(100, 2/2, 2/2, center=true);
	}
}

module screwtab() {
	rounding=2;
	tabrad=7.4;
	tabheight=6;
	drill=2;

	holecenter = max(rounding+drill*2, tabrad);
	difference(){
		translate([0,-1,0])xcube(tabrad*2,rounding+1,tabheight);
		translate([ tabrad,rounding,0])cylinder(100, rounding, rounding, center=true);
		translate([-tabrad,rounding,0])cylinder(100, rounding, rounding, center=true);

		translate([0,rounding,tabheight])rotate([0,90,0])cylinder(100, rounding, rounding, center=true);

		translate([0,holecenter,tabheight-rounding])cylinder(100, drill*3, drill*3);
	}
	difference(){
		union(){
			translate([0,holecenter,0])cylinder(tabheight-rounding, tabrad-rounding, tabrad-rounding);
			xcube(tabrad*2-rounding*2,holecenter,tabheight-rounding);
		}
		translate([0,holecenter,0])cylinder(100, drill, drill, center=true);
	}
}

module battholder(tabs=true) {
	difference(){
		translate([-battspacing/2-2, -battspacing/2-2, -3])xyroundedcube(battsx*battspacing+4, battsy*battspacing+4, 10, 4);
		for(i=[0:battsx-1]) {
			for(j=[0:battsy-1]) {
				translate([battspacing*i, battspacing*j, 0])battcutout();
			}
		}


		translate([battspacing/2, battspacing/2, 0])printablenuthole();
		translate([battspacing*battsx-battspacing*3/2, battspacing*battsy-battspacing*3/2, 0])printablenuthole();
		translate([battspacing*battsx-battspacing*3/2, battspacing/2, 0])printablenuthole();
		translate([battspacing/2, battspacing*battsy-battspacing*3/2, 0])printablenuthole();
	}
	if(tabs){
		translate([battspacing/2, -battspacing/2-2, -3])rotate([0,0,180])screwtab();
		translate([battspacing*battsx-battspacing*3/2, battspacing*battsy-battspacing/2+2, -3])screwtab();
		translate([battspacing/2, battspacing*battsy-battspacing/2+2, -3])screwtab();
		translate([battspacing*battsx-battspacing*3/2, -battspacing/2-2, -3])rotate([0,0,180])screwtab();
	}
}
//render it
battholder(tabs=includetabs);
