package main

const (
	A1 = 1
	A2 = 2
	B  = 4
	C  = 8
	D1 = 16
	D2 = 32
	E  = 64
	F  = 128
	G1 = 256
	G2 = 512
	H  = 1024
	I  = 2048
	J  = 4096
	K  = 8192
	L  = 16384
	M  = 32768
)

func segs2lines(mask uint16) []float32 {
	var rv []float32
	a1 := []float32{0, 2, 0, 0.5, 2, 0}
	a2 := []float32{0.5, 2, 0, 1, 2, 0}
	b := []float32{1, 2, 0, 1, 1, 0}
	c := []float32{1, 1, 0, 1, 0, 0}
	d1 := []float32{0, 0, 0, 0.5, 0, 0}
	d2 := []float32{0.5, 0, 0, 1, 0, 0}
	e := []float32{0, 0, 0, 0, 1, 0}
	f := []float32{0, 1, 0, 0, 2, 0}
	g1 := []float32{0, 1, 0, 0.5, 1, 0}
	g2 := []float32{0.5, 1, 0, 1, 1, 0}
	h := []float32{0, 2, 0, 0.5, 1, 0}
	i := []float32{0.5, 2, 0, 0.5, 1, 0}
	j := []float32{1, 2, 0, 0.5, 1, 0}
	k := []float32{0, 0, 0, 0.5, 1, 0}
	l := []float32{0.5, 0, 0, 0.5, 1, 0}
	m := []float32{1, 0, 0, 0.5, 1, 0}

	a1_f := []float32{0.25, 2, 0, 0.5, 2, 0, 0, 1, 0, 0, 1.75, 0, 0, 1.75, 0, 0.25, 2, 0}
	c_d2 := []float32{1, 1, 0, 1, 0.25, 0, 0.5, 0, 0, 0.75, 0, 0, 0.75, 0, 0, 1, 0.25, 0}

	if (mask&A1 != 0) && (mask&F != 0) {
		rv = append(rv, a1_f...)
	} else if mask&A1 != 0 {
		rv = append(rv, a1...)
	} else if mask&F != 0 {
		rv = append(rv, f...)
	}
	if mask&A2 != 0 {
		rv = append(rv, a2...)
	}
	if mask&B != 0 {
		rv = append(rv, b...)
	}
	if (mask&C != 0) && (mask&D2 != 0) {
		rv = append(rv, c_d2...)
	} else if mask&C != 0 {
		rv = append(rv, c...)
	} else if mask&D2 != 0 {
		rv = append(rv, d2...)
	}
	if mask&D1 != 0 {
		rv = append(rv, d1...)
	}
	if mask&E != 0 {
		rv = append(rv, e...)
	}
	if mask&G1 != 0 {
		rv = append(rv, g1...)
	}
	if mask&G2 != 0 {
		rv = append(rv, g2...)
	}
	if mask&H != 0 {
		rv = append(rv, h...)
	}
	if mask&I != 0 {
		rv = append(rv, i...)
	}
	if mask&J != 0 {
		rv = append(rv, j...)
	}
	if mask&K != 0 {
		rv = append(rv, k...)
	}
	if mask&L != 0 {
		rv = append(rv, l...)
	}
	if mask&M != 0 {
		rv = append(rv, m...)
	}
	return rv
}

func char2segs(letter rune) uint16 {
	var ascii uint8
	if uint32(letter) > 0xff {
		ascii = uint8('-')
	} else {
		ascii = uint8(letter)
	}
	switch ascii {
	case uint8('0'):
		return A1 | A2 | B | C | D1 | D2 | E | F
	case uint8('1'):
		return I | L
	case uint8('2'):
		return A1 | A2 | B | G2 | G1 | E | D1 | D2
	case uint8('3'):
		return A1 | A2 | B | G2 | C | D1 | D2
	case uint8('4'):
		return F | G1 | G2 | B | C
	case uint8('5'):
		return A1 | A2 | F | G1 | G2 | C | D1 | D2
	case uint8('6'):
		return A1 | A2 | F | E | G1 | G2 | C | D1 | D2
	case uint8('7'):
		return A1 | A2 | J | L
	case uint8('8'):
		return A1 | A2 | B | C | D1 | D2 | E | F | G1 | G2
	case uint8('9'):
		return A1 | A2 | B | C | D1 | D2 | F | G1 | G2
	case uint8('A'):
		return E | F | A1 | A2 | B | C | G1 | G2
	case uint8('B'):
		return A1 | A2 | B | C | D1 | D2 | I | L | G2
	case uint8('C'):
		return A1 | A2 | F | E | D1 | D2
	case uint8('D'):
		return A1 | A2 | B | C | D1 | D2 | I | L
	case uint8('E'):
		return A1 | A2 | F | E | D1 | D2 | G1
	case uint8('F'):
		return A1 | A2 | F | E | G1
	case uint8('G'):
		return A1 | A2 | F | E | D1 | D2 | C | G2
	case uint8('H'):
		return F | E | G1 | G2 | B | C
	case uint8('I'):
		return A1 | A2 | I | L | D1 | D2
	case uint8('J'):
		return B | C | D1 | D2 | E
	case uint8('K'):
		return F | E | G1 | J | M
	case uint8('L'):
		return F | E | D1 | D2
	case uint8('M'):
		return E | F | H | J | B | C
	case uint8('N'):
		return E | F | H | M | B | C
	case uint8('O'): //same as 0
		return A1 | A2 | B | C | D1 | D2 | E | F
	case uint8('P'):
		return E | F | A1 | A2 | B | G2 | G1
	case uint8('Q'):
		return A1 | A2 | B | C | D1 | D2 | E | F | M
	case uint8('R'):
		return E | F | A1 | A2 | B | G2 | G1 | M
	case uint8('S'): //same as 5
		return A1 | A2 | F | G1 | G2 | C | D1 | D2
	case uint8('T'):
		return A1 | A2 | I | L
	case uint8('U'):
		return F | E | D1 | D2 | C | B
	case uint8('V'):
		return F | E | K | J
	case uint8('W'):
		return F | E | K | M | C | B
	case uint8('X'):
		return H | J | K | M
	case uint8('Y'):
		return H | J | L
	case uint8('Z'):
		return A1 | A2 | J | K | D1 | D2
	case uint8('-'):
		return G1 | G2
	default:
		return D2 | D1
	}
}
func char2lines(letter rune) []float32 {
	return segs2lines(char2segs(letter))
}
