package main

import "fmt"

type Axis2D struct {
	minx float32
	maxx float32
	miny float32
	maxy float32
}

func digitlines(digitin int) []float32 {
	return char2lines(rune(uint8(digitin) + '0'))
}

func xlatscale(translate [3]float32, scale [3]float32, in []float32) []float32 {
	var rv []float32
	for i, val := range in {
		rv = append(rv, val*scale[i%3]+translate[i%3])
	}
	return rv
}

//return power of ten close to input
//problem: float can't store 0.1
func order(num float32) float32 {
	rv := float32(1)
	if rv > num {
		for i := 0; i < 100; i++ {
			rv /= 10
			if rv < num {
				return rv * 10
			}
		}
	} else {
		for i := 0; i < 100; i++ {
			if rv > num {
				return rv
			}
			rv *= 10
		}
	}
	//can't happen
	return rv
}

func digitstring(num float32) []float32 {
	var rv []float32
	do_minus := false
	if num < 0 {
		//TODO: negative sign
		do_minus = true
		num = -num
	}
	//whole part
	digit := 0
	for i := 1; i < 100000000; i *= 10 {
		digitnum := int(num/float32(i)) % 10
		rv = append(rv, xlatscale([3]float32{-float32(digit) * 1.1, 0, 0}, [3]float32{0.8, 0.8, 0.8}, digitlines(digitnum))...)
		digit++
		if float32(i*10) > num {
			break
		}
	}
	if do_minus {
		rv = append(rv, xlatscale([3]float32{-float32(digit) * 1.1, 0, 0}, [3]float32{0.8, 0.8, 0.8}, char2lines('-'))...)
	}
	//decimal point
	rv = append(rv, []float32{1.1, 0, 0, 1.3, 0, 0}...)
	//fractional part
	fracdigit := 0
	for i := 10; i < 1000000; i *= 10 {
		digitnum := int(num*float32(i)+0.00001 /*fudge factor?*/) % 10
		rv = append(rv, xlatscale([3]float32{1.5 + float32(fracdigit)*1.1, 0, 0}, [3]float32{0.8, 0.8, 0.8}, digitlines(digitnum))...)
		fracdigit++
		//stop when we would have zeros at the end
		if int(num*float32(i)*1000+0.5 /*fudge factor?*/)%1000 == 0 {
			break
		}
	}
	//for _, letter := range "THE QUICK RED FOX JUMPS OVER THE LAZY BROWN DOG" {
	//	rv = append(rv, xlatscale([3]float32{1.5 + float32(digit)*1.1, 0, 0}, [3]float32{0.8, 0.8, 0.8}, char2lines(letter))...)
	//	digit ++
	//}
	return xlatscale([3]float32{float32(digit-2) * 1.1, 0, 0}, [3]float32{1, 1, 1}, rv)
}

//returns lines in 3d space (x,y,z)
func (a Axis2D) Lines() []float32 {
	var rv []float32

	vsx := (a.maxx - a.minx) / 10 * 4
	vsy := (a.maxy - a.miny) / 10 * 4

	//base x axis line
	rv = append(rv, a.minx)
	rv = append(rv, a.miny)
	rv = append(rv, 0)
	rv = append(rv, a.maxx)
	rv = append(rv, a.miny)
	rv = append(rv, 0)
	// x marks
	incx := order(a.maxx-a.minx) / 10
	if incx/(a.maxx-a.minx) > 0.5 {
		// Going from 0..1..2 to 0..10..20 can be dramatic, so add intermediate 0..5..10 step
		incx /= 2
	}
	startx := float32(int(a.minx/incx)) * incx
	for i := startx; i < a.maxx+incx*2; i += incx {
		rv = append(rv, i)
		rv = append(rv, a.miny-vsy/20)
		rv = append(rv, 0)
		rv = append(rv, i)
		rv = append(rv, a.miny+vsy/20)
		rv = append(rv, 0)
		rv = append(rv, xlatscale([3]float32{i, a.miny + vsy/20 + vsy/100, 0}, [3]float32{vsx / 40, vsy / 40, vsx / 40}, digitstring(i))...)
		for j := i - incx; j < i; j += incx / 10 {
			rv = append(rv, j)
			rv = append(rv, a.miny-vsy/40)
			rv = append(rv, 0)
			rv = append(rv, j)
			rv = append(rv, a.miny+vsy/40)
			rv = append(rv, 0)
			if len(rv) > 10000 {
				fmt.Println("x axis generation went wrong")
				break
			}
		}
		if len(rv) > 10000 {
			fmt.Println("x axis generation went wrong")
			break
		}
	}

	//base y axis line
	incy := order(a.maxy-a.miny) / 10
	if incy/(a.maxy-a.miny) > 0.5 {
		incy /= 2
	}
	starty := float32(int(a.miny/incy)) * incy
	rv = append(rv, a.minx)
	rv = append(rv, a.miny)
	rv = append(rv, 0)
	rv = append(rv, a.minx)
	rv = append(rv, a.maxy)
	rv = append(rv, 0)
	// y marks
	for i := starty; i < a.maxy+incy*2; i += incy {
		rv = append(rv, a.minx-vsx/20)
		rv = append(rv, i)
		rv = append(rv, 0)
		rv = append(rv, a.minx+vsx/20)
		rv = append(rv, i)
		rv = append(rv, 0)
		rv = append(rv, xlatscale([3]float32{a.minx + vsx*2/20 + vsx/100, i, 0}, [3]float32{vsx / 40, vsy / 40, vsy / 40}, digitstring(i))...)
		for j := i - incy; j < i; j += incy / 10 {
			rv = append(rv, a.minx-vsx/40)
			rv = append(rv, j)
			rv = append(rv, 0)
			rv = append(rv, a.minx+vsx/40)
			rv = append(rv, j)
			rv = append(rv, 0)
			if len(rv) > 20000 {
				fmt.Println("x axis generation went wrong")
				break
			}
		}
		if len(rv) > 20000 {
			fmt.Println("x axis generation went wrong")
			break
		}
	}
	return rv
}
