package main

import "gaem"

func init() {
	gaem.HardcodeAsset( "shader", "graphcopy2screen.vs", []byte(`#version 420
out vec2 uvpos;

uniform vec2 screenres;

layout(binding=0)uniform sampler2D color;

void main(){
	if (gl_VertexID == 0)
		gl_Position = vec4(-1, -1, 0, 1);
	else if (gl_VertexID == 1)
		gl_Position = vec4(1, -1, 0, 1);
	else if (gl_VertexID == 2)
		gl_Position = vec4(1, 1, 0, 1);
	else if (gl_VertexID == 3)
		gl_Position = vec4(-1, 1, 0, 1);
	uvpos = (gl_Position.xy)*0.5+vec2(0.5,0.5);
	uvpos = uvpos * screenres/textureSize(color, 0);
}

`))
	gaem.HardcodeAsset( "shader", "graphcopy2screen.fs", []byte(`#version 420
layout(location=0)out vec3 col;

in vec2 uvpos;

//sRGB
layout(binding=0)uniform sampler2D color;
//linear
layout(binding=1)uniform usampler2D not_used;

void main(){
	col = texture(color, uvpos).xyz;
}

`))
	gaem.HardcodeAsset( "shader", "graphlines.vs", []byte(`#version 420
layout(location = 1) in float xpos;
layout(location = 2) in float ypos;
layout(location = 3) in float zpos;
layout(location = 4) in float size;
layout(location = 5) in float rcol;
layout(location = 6) in float gcol;
layout(location = 7) in float bcol;
layout(location = 8) in float acol;

uniform mat4 graphxfrm;
uniform uint startuid;

out vec4 rgba;
flat out uint uid_to_frag;
void main(){
	vec4 xyz = vec4(xpos, ypos, zpos, 1);
	xyz = (graphxfrm * xyz);
	xyz /= xyz.w;

	gl_Position = xyz;

	rgba = vec4(rcol, gcol, bcol, acol);

	//hack to reduce depth clipping
	gl_Position.z /= 1000;
	uid_to_frag = startuid + gl_VertexID;
}


`))
	gaem.HardcodeAsset( "shader", "graphlines.fs", []byte(`#version 420
layout(location=0)out vec4 col;
layout(location=1)out uint id;

uniform vec3 colorshift;

in vec4 rgba;
flat in uint uid_to_frag;
void main(){
	//col = vec4(0.5);
	col = rgba;
	col.rgb *= (colorshift + vec3(1));
	id = uid_to_frag;
}

`))
	gaem.HardcodeAsset( "shader", "graphcandles.vs", []byte(`#version 420
layout(location = 1) in float xpos;
layout(location = 2) in float yopen;
layout(location = 3) in float zpos;
//Unlike graphpoints, this should be in graph-space units
layout(location = 4) in float size;
layout(location = 5) in float rcol;
layout(location = 6) in float gcol;
layout(location = 7) in float bcol;
layout(location = 8) in float acol;
layout(location = 9) in float yclose;
layout(location = 10) in float miny;
layout(location = 11) in float maxy;

uniform mat4 graphxfrm;
uniform vec2 screenres;
uniform uint startuid;

out vec4 rgba;
flat out uint uid_to_frag;
void main(){
	vec4 xyz_open = vec4(xpos, yopen, zpos, 1);
	xyz_open = (graphxfrm * xyz_open);
	xyz_open /= xyz_open.w;

	vec4 xyz_close = vec4(xpos, yclose, zpos, 1);
	xyz_close = (graphxfrm * xyz_close);
	xyz_close /= xyz_close.w;

	vec4 xyz_min = vec4(xpos, miny, zpos, 1);
	xyz_min = (graphxfrm * xyz_min);
	xyz_min /= xyz_min.w;

	vec4 xyz_max = vec4(xpos, maxy, zpos, 1);
	xyz_max = (graphxfrm * xyz_max);
	xyz_max /= xyz_max.w;

	//Offset the top and right sides of candle and wick by 1 pixel screen space
	//This prevents candles from disappearing when you zoom out
	vec4 toprightoffset = vec4(2.0/screenres.x, 2.0/screenres.y, 0,0);

	float sortedtop = max(yopen, yclose);
	float sortedbot = min(yopen, yclose);

	//candle
	if (gl_VertexID == 0 || gl_VertexID == 3)
		//top left
		gl_Position = graphxfrm * vec4(xpos - size/2,sortedtop, zpos, 1) + toprightoffset.wyww;
	else if (gl_VertexID == 1)
		//top right
		gl_Position = graphxfrm * vec4(xpos + size/2,sortedtop, zpos, 1) + toprightoffset.xyww;
	else if (gl_VertexID == 2|| gl_VertexID == 4)
		//bottom right
		gl_Position = graphxfrm * vec4(xpos + size/2,sortedbot, zpos, 1) + toprightoffset.xwww;
	else if (gl_VertexID == 5)
		//bottom left
		gl_Position = graphxfrm * vec4(xpos - size/2,sortedbot, zpos, 1);
	//wick
	else if (gl_VertexID == 6 || gl_VertexID == 9)
		gl_Position = graphxfrm * vec4(xpos - size/8,miny, zpos, 1) + toprightoffset.wyww;
	else if (gl_VertexID == 7)
		gl_Position = graphxfrm * vec4(xpos + size/8,miny, zpos, 1) + toprightoffset.xyww;
	else if (gl_VertexID == 8 || gl_VertexID == 10)
		gl_Position = graphxfrm * vec4(xpos + size/8,maxy, zpos, 1) + toprightoffset.xwww;
	else if (gl_VertexID == 11)
		gl_Position = graphxfrm * vec4(xpos - size/8,maxy, zpos, 1);

	if (yopen < yclose)
		rgba = vec4(rcol, gcol, bcol, acol);
	else
		rgba = vec4(gcol, rcol, bcol, acol);

	//hack to reduce depth clipping
	gl_Position.z /= 1000;

	uid_to_frag = startuid + gl_InstanceID;
}


`))
	gaem.HardcodeAsset( "shader", "graphcandles.fs", []byte(`#version 420
layout(location=0)out vec4 col;
layout(location=1)out uint id;

uniform vec3 colorshift;

in vec4 rgba;
flat in uint uid_to_frag;
void main(){
	//col = vec4(0.5);
	col = rgba;
	col.rgb *= (colorshift + vec3(1));
	id = uid_to_frag;
}

`))
	gaem.HardcodeAsset( "shader", "graphpoints.vs", []byte(`#version 420
layout(location = 1) in float xpos;
layout(location = 2) in float ypos;
layout(location = 3) in float zpos;
layout(location = 4) in float size;
layout(location = 5) in float rcol;
layout(location = 6) in float gcol;
layout(location = 7) in float bcol;
layout(location = 8) in float acol;

uniform mat4 graphxfrm;
uniform uint startuid;

out vec4 rgba;
flat out uint uid_to_frag;
void main(){
	vec4 xyz = vec4(xpos, ypos, zpos, 1);
	xyz = (graphxfrm * xyz);
	xyz /= xyz.w;

	float realsize = max(size, 1.0/256);

	if (gl_VertexID == 0)
		gl_Position = xyz+vec4(-realsize, -realsize, 0, 0);
	else if (gl_VertexID == 1)
		gl_Position = xyz+vec4(realsize, -realsize, 0, 0);
	else if (gl_VertexID == 2)
		gl_Position = xyz+vec4(realsize, realsize, 0, 0);
	else if (gl_VertexID == 3)
		gl_Position = xyz+vec4(-realsize, realsize, 0, 0);
	rgba = vec4(rcol, gcol, bcol, acol);

	//hack to reduce depth clipping
	gl_Position.z /= 1000;
	uid_to_frag = startuid + gl_InstanceID;
}


`))
	gaem.HardcodeAsset( "shader", "graphpoints.fs", []byte(`#version 420
layout(location=0)out vec4 col;
layout(location=1)out uint id;

uniform vec3 colorshift;
in vec4 rgba;
flat in uint uid_to_frag;
void main(){
	//col = vec4(0.5);
	col = rgba;
	col.rgb *= (colorshift + vec3(1));
	id = uid_to_frag;
}

`))
	gaem.HardcodeAsset( "pipeline", "graph.json", []byte(`[
{
	"Fbo": "staging",
	"Textures": {
	},
	"RenderType": "triangles",
	"Shader": "graphpoints",
	"Clearfirst":true,
	"Materials": ["Scatter"]
},
{
	"Fbo": "staging",
	"Textures": {
	},
	"RenderType": "lines",
	"Shader": "graphlines",
	"Clearfirst":false,
	"Materials": ["Line"]
},
{
	"Fbo": "staging",
	"Textures": {
	},
	"RenderType": "triangles",
	"Shader": "graphcandles",
	"Clearfirst":false,
	"Materials": ["Candle"]
},
{
	"Fbo": "staging",
	"Textures": {
	},
	"RenderType": "lines",
	"Shader": "lines",
	"Clearfirst":false
},
{
	"Fbo": "",
	"FboTextures": {
		"0": {"Fbo":"staging", "Index":0 , "Kind":"color", "AbsSize":[4096, 4096]},
		"1": {"Fbo":"staging", "Index":1 , "Kind":"uint32", "AbsSize":[4096, 4096]}
	},
	"RenderType": "triangles",
	"Shader": "graphcopy2screen",
	"Clearfirst":false
}
]
`))
	gaem.HardcodeAsset( "shader", "lines.vs", []byte(`#version 420
layout(location = 1) in vec3 pos;

uniform mat4 graphxfrm;

void main(){
	vec4 xyz = vec4(pos, 1);
	xyz = (graphxfrm * xyz);
	xyz /= xyz.w;

	gl_Position = xyz;

	//hack to reduce depth clipping
	gl_Position.z /= 1000;
}


`))
	gaem.HardcodeAsset( "shader", "lines.fs", []byte(`#version 420
layout(location=0)out vec4 col;

void main(){
	//col = vec4(0.5);
	col = vec4(1,0,0,1);
	//col = rgba;
}

`))
}
