package gaem

import "github.com/go-gl/glfw/v3.3/glfw"
import "github.com/go-gl/gl/v4.1-core/gl"
import "runtime"

func Init() {
	glfw.Init()
}

// This should include all context (shaders, buffers, etc.)
type Win struct {
	win *glfw.Window
}

func (w Win) Flip() {
	w.win.SwapBuffers()
	glfw.PollEvents()

}
func (w Win) ShouldClose() bool {
	return w.win.ShouldClose()
}
func (w Win) Close() {
	//TODO: remove from wins
	w.win.Destroy()
}

//GLOBAL
var wins []Win

//future operations MUST be run from the same thread that calls this
func NewWin(w int, h int, title string) Win {
	var rv Win
	runtime.LockOSThread()
	if len(wins) > 0 {
		// share some things with previous window
		rv.win, _ = glfw.CreateWindow(w, h, title, nil, wins[0].win)
	} else {
		rv.win, _ = glfw.CreateWindow(w, h, title, nil, nil)
	}
	rv.win.MakeContextCurrent()
	gl.Init()
	DumpErr()
	wins = append(wins, rv)
	return rv
}
