package gaem

import "github.com/go-gl/gl/v4.1-core/gl"
import "fmt"

type Vao struct {
	vbos       []uint32
	ibo        uint32
	vao        uint32
	Numindices int
}

func NewVao() Vao {
	rv := Vao{}
	gl.GenVertexArrays(1, &rv.vao)
	DumpErr()
	gl.BindVertexArray(rv.vao)
	DumpErr()
	//NOTE: we are guaranteed at least 16 per the spec, so use 16 everywhere for max compatibility
	//maxv := int32(0)
	//gl.GetIntegerv(gl.MAX_VERTEX_ATTRIBS, &maxv)
	//fmt.Printf("max %d vertex attribs\n", maxv)
	//rv.vbos = make([]uint32, maxv)
	rv.vbos = make([]uint32, 16)

	//wasteful of VBO IDs, does this matter?
	for i := range rv.vbos {
		gl.GenBuffers(1, &rv.vbos[i])
		DumpErr()
	}
	gl.GenBuffers(1, &rv.ibo)
	DumpErr()

	return rv
}
func (v *Vao) AddVbof(index int, data []float32, elements int) error {
	if index >= len(v.vbos) {
		return fmt.Errorf("VBO index out of range (max %d, asked for %d)", len(v.vbos)-1, index)
	}
	gl.BindVertexArray(v.vao)
	DumpErr()
	gl.BindBuffer(gl.ARRAY_BUFFER, v.vbos[index])
	DumpErr()
	gl.BufferData(gl.ARRAY_BUFFER, len(data)*4, gl.Ptr(data), gl.STATIC_DRAW)
	DumpErr()
	gl.EnableVertexAttribArray(uint32(index))
	DumpErr()
	gl.VertexAttribPointer(uint32(index), int32(elements), gl.FLOAT, false, 0, gl.Ptr(nil))
	DumpErr()
	return nil
}
func (v *Vao) AddVboInstancedf(index int, data []float32, elements int) error {
	if index >= len(v.vbos) {
		return fmt.Errorf("VBO index out of range (max %d, asked for %d)", len(v.vbos)-1, index)
	}
	gl.BindVertexArray(v.vao)
	DumpErr()
	gl.BindBuffer(gl.ARRAY_BUFFER, v.vbos[index])
	DumpErr()
	gl.BufferData(gl.ARRAY_BUFFER, len(data)*4, gl.Ptr(data), gl.STREAM_DRAW)
	DumpErr()
	gl.EnableVertexAttribArray(uint32(index))
	DumpErr()
	gl.VertexAttribPointer(uint32(index), int32(elements), gl.FLOAT, false, 0, gl.Ptr(nil))
	gl.VertexAttribDivisor(uint32(index), 1)
	DumpErr()
	return nil
}
func (v *Vao) UpdateVbof(index int, data []float32, elements int) error {
	if index >= len(v.vbos) {
		return fmt.Errorf("VBO index out of range (max %d, asked for %d)", len(v.vbos)-1, index)
	}
	gl.BindBuffer(gl.ARRAY_BUFFER, v.vbos[index])
	//NOTE: this won't work if the array isn't big enough
	gl.BufferSubData(gl.ARRAY_BUFFER, 0, len(data)*4, gl.Ptr(data))
	return nil
}
func (v *Vao) AddIboi(data []int32) error {
	gl.BindVertexArray(v.vao)
	DumpErr()
	gl.BindBuffer(gl.ELEMENT_ARRAY_BUFFER, v.ibo)
	DumpErr()
	gl.BufferData(gl.ELEMENT_ARRAY_BUFFER, len(data)*4, gl.Ptr(data), gl.STATIC_DRAW)
	DumpErr()
	v.Numindices = len(data)
	return nil
}
func (v *Vao) Bind() {
	gl.BindVertexArray(v.vao)
}
