package gaem

import "fmt"
import "github.com/go-gl/gl/v4.1-core/gl"
import _ "image/png"
import "image"
import "bytes"
import "reflect"

type texture uint32

func NamedTexture(name string) (texture, error) {
	data, err := LoadAsset("tex", name)
	if err != nil {
		return 0, err
	}
	img, _, err := image.Decode(bytes.NewReader(data))
	if err != nil {
		return 0, err
	}
	if nrgba, ok := img.(*image.NRGBA); ok {
		var rv uint32
		gl.GenTextures(1, &rv)
		gl.BindTexture(gl.TEXTURE_2D, rv)
		gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_S, gl.REPEAT)
		gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_WRAP_T, gl.REPEAT)

		gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR_MIPMAP_LINEAR)
		gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR)
		gl.TexParameterf(gl.TEXTURE_2D, gl.TEXTURE_MAX_ANISOTROPY, 2)

		if nrgba.Bounds().Max.X*4 != nrgba.Stride {
			fmt.Printf("FIXME: stride %d differs from texture width %d*4, %s\n", nrgba.Stride, nrgba.Bounds().Max.X, name)
		}
		gl.TexImage2D(gl.TEXTURE_2D, 0, gl.RGBA, int32(nrgba.Bounds().Max.X), int32(nrgba.Bounds().Max.Y), 0, gl.RGBA, gl.UNSIGNED_BYTE, gl.Ptr(nrgba.Pix))
		DumpErr()
		gl.GenerateMipmap(gl.TEXTURE_2D)
		DumpErr()

		return texture(rv), nil
	} else {
		return 0, fmt.Errorf("texture %s decoded unrecognized format %s", name, reflect.TypeOf(img))
	}
}
func (t texture) BindTexToUnit(unit int) {
	gl.ActiveTexture(uint32(gl.TEXTURE0 + unit))
	gl.BindTexture(gl.TEXTURE_2D, uint32(t))
}
