package gaem

import "github.com/go-gl/gl/v4.1-core/gl"
import "fmt"

type Fbo struct {
	fbo           uint32
	textures      map[int]texture
	width, height int
}

func NewFbo(width, height int) Fbo {
	rv := Fbo{width: width, height: height}
	gl.GenFramebuffers(1, &rv.fbo)
	DumpErr()
	//gl.BindFramebuffer(gl.DRAW_FRAMEBUFFER, rv.fbo)
	//DumpErr()
	rv.textures = make(map[int]texture)
	return rv
}

func (f *Fbo) addTex(index int, internalformat int32, format uint32, attach uint32) {
	var newtex uint32
	gl.GenTextures(1, &newtex)
	gl.ActiveTexture(uint32(gl.TEXTURE0 + 42))
	gl.BindTexture(gl.TEXTURE_2D, newtex)
	gl.TexImage2D(gl.TEXTURE_2D, 0, internalformat, int32(f.width), int32(f.height), 0, format, gl.UNSIGNED_BYTE, gl.Ptr(nil))
	f.textures[index] = texture(newtex)
	DumpErr()
	gl.BindFramebuffer(gl.FRAMEBUFFER, f.fbo)
	DumpErr()
	gl.FramebufferTexture2D(gl.FRAMEBUFFER, attach, gl.TEXTURE_2D, newtex, 0)
	DumpErr()
	if fbok := gl.CheckFramebufferStatus(gl.FRAMEBUFFER); fbok != gl.FRAMEBUFFER_COMPLETE {
		fmt.Println("framebuffer complete?", gl.CheckFramebufferStatus(gl.FRAMEBUFFER), "ok=", gl.FRAMEBUFFER_COMPLETE, "missing=", gl.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT)
	}
	DumpErr()
	gl.BindTexture(gl.TEXTURE_2D, 0)
	if index >= 0 {
		maxbuffer := -1
		for attach := range f.textures {
			if attach > maxbuffer {
				maxbuffer = attach
			}
		}
		//NOTE: not sure what happens if output does not exist, so probably best to make them contiguous in the pipeline
		drawbuffers := []uint32{}
		for i := 0; i <= maxbuffer; i++ {
			drawbuffers = append(drawbuffers, gl.COLOR_ATTACHMENT0+uint32(i))
		}
		//Tell it to actually use the new buffer
		if len(drawbuffers) > 0 {
			gl.DrawBuffers(int32(len(drawbuffers)), &drawbuffers[0])
		}
	}
}
func (f *Fbo) AddDepthTex() {
	f.addTex(-1, gl.DEPTH_COMPONENT24, gl.DEPTH_COMPONENT, gl.DEPTH_ATTACHMENT)
}
func (f *Fbo) AddFloatTex(index int) {
	f.addTex(index, gl.RGBA32F, gl.RGBA, uint32(gl.COLOR_ATTACHMENT0+index))
}
func (f *Fbo) AddColorTex(index int) {
	f.addTex(index, gl.RGBA, gl.RGBA, uint32(gl.COLOR_ATTACHMENT0+index))
}
func (f *Fbo) AddUint32Tex(index int) {
	f.addTex(index, gl.R32UI, gl.RED_INTEGER, uint32(gl.COLOR_ATTACHMENT0+index))
}
func (f *Fbo) RenderTarget() {
	gl.Viewport(0, 0, int32(f.width), int32(f.height))
	gl.BindFramebuffer(gl.FRAMEBUFFER, f.fbo)
}
func (f *Fbo) ReadDepth() []uint32 {
	gl.BindFramebuffer(gl.READ_FRAMEBUFFER, f.fbo)
	buf := make([]uint32, f.width*f.height)
	gl.ReadPixels(0, 0, int32(f.width), int32(f.height), gl.DEPTH_COMPONENT, gl.UNSIGNED_INT, gl.Ptr(buf))
	return buf
}
func (f *Fbo) ReadUint32(index int) []uint32 {
	gl.BindFramebuffer(gl.READ_FRAMEBUFFER, f.fbo)
	buf := make([]uint32, f.width*f.height)
	DumpErr()
	gl.GetTextureImage(uint32(f.textures[index]), 0, gl.RED_INTEGER, gl.UNSIGNED_INT, int32(len(buf)*4), gl.Ptr(buf))
	DumpErr()
	return buf
}

//send channel to texture unit
func (f *Fbo) BindChannelToUnit(channel, unit int) {
	gl.ActiveTexture(uint32(gl.TEXTURE0 + unit))
	gl.BindTexture(gl.TEXTURE_2D, uint32(f.textures[channel]))
	gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.NEAREST)
	gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.NEAREST)
}
func (f *Fbo) BindChannelToUnitLinear(channel, unit int) {
	gl.ActiveTexture(uint32(gl.TEXTURE0 + unit))
	gl.BindTexture(gl.TEXTURE_2D, uint32(f.textures[channel]))
	gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, gl.LINEAR)
	gl.TexParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, gl.LINEAR)
}
func RenderTargetScreen() {
	DumpErr()
	gl.BindFramebuffer(gl.FRAMEBUFFER, 0)
	DumpErr()
}
func (f *Fbo) GetDim() (int, int) {
	return f.width, f.height
}
