package gaem

import "github.com/go-gl/gl/v4.1-core/gl"
import "fmt"
import "runtime/debug"

func err2str(err uint32) string {
	switch err {
	case gl.INVALID_ENUM:
		return "invalid enum"
	case gl.INVALID_OPERATION:
		return "invalid operation"
	case gl.INVALID_VALUE:
		return "invalid value"
	}
	return "???"
}

var numerrs int

func DumpErr() {
	eid := gl.GetError()
	if eid != gl.NO_ERROR {
		fmt.Println("OpenGL error", eid, "(", err2str(eid), ")")
		debug.PrintStack()
		//panic("gl error");
		numerrs += 1
		if numerrs > 2 {
			panic("too many errors")
		}
	}
}
