package gaem

import "github.com/go-gl/mathgl/mgl32"
import "math"

type Camera struct {
	Loc  [3]float32
	Long float32
	Lat  float32
}

//TODO: check signs
func (c Camera) Mat() mgl32.Mat4 {
	rv := mgl32.Diag4(mgl32.Vec4{1, 1, 1, 1})
	rv = rv.Mul4(mgl32.HomogRotate3DX(c.Lat))
	rv = rv.Mul4(mgl32.HomogRotate3DZ(c.Long))
	rv = rv.Mul4(mgl32.Translate3D(c.Loc[0], c.Loc[1], c.Loc[2]))
	return rv
}
func (c *Camera) MoveZ(dist float32) {
	c.Loc[2] += dist
}
func (c *Camera) MoveX(dist float32) {
	c.Loc[0] += dist * float32(math.Cos(float64(c.Long)))
	c.Loc[1] -= dist * float32(math.Sin(float64(c.Long)))
}
func (c *Camera) MoveY(dist float32) {
	c.Loc[0] -= dist * float32(math.Sin(-float64(c.Long)))
	c.Loc[1] += dist * float32(math.Cos(-float64(c.Long)))
}
