package gaem

import "io/ioutil"
import "path"

var hardcodedassets map[string][]byte

func HardcodeAsset(kind string, name string, data []byte) {
	if hardcodedassets == nil {
		hardcodedassets = make(map[string][]byte)
	}
	hardcodedassets[kind+"/"+name] = data
}

func LoadAsset(kind string, name string) ([]byte, error) {
	if hardcodedassets != nil {
		if val, ok := hardcodedassets[kind+"/"+name]; ok {
			return val, nil
		}
	}
	fp := path.Join("assets", kind, name)
	return ioutil.ReadFile(fp)
}
